//
//  RVProtocolCommands.h
//  CommunicationModule
//
//  Created by Greg Harris on 8/1/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#ifndef CommunicationModule_RVProtocolCommands_h
#define CommunicationModule_RVProtocolCommands_h

// REQUIRED
/*
 RVProtocolCommandKeyDisplayName: name of the command to be displayed in a selection list
 */
#define RVProtocolCommandKeyDisplayName @"RVProtocolCommandKeyDisplayName"
/*
 RVProtocolCommandKeyFormat: the actual command string to be sent, variables are entered as placeholder text and then replaced with values entered based on the params
 */
#define RVProtocolCommandKeyFormat @"RVProtocolCommandKeyFormat"

// OPTIONAL
/*
 RVProtocolCommandKeyDescription: short description of command
 */
#define RVProtocolCommandKeyDescription @"RVProtocolCommandKeyDescription"
/*
 RVProtocolCommandKeyIndex: the listing order of the command, lower numbers will be listed first
 */
#define RVProtocolCommandKeyIndex @"RVProtocolCommandKeyIndex"
/*
 RVProtocolCommandKeyParams: array of dictionaries with keys below
 */
#define RVProtocolCommandKeyParams @"RVProtocolCommandKeyParams"
/*
 RVProtocolCommandKeyBreakIndexes: NSIndexSet containing the indexes at which to pause
 */
#define RVProtocolCommandKeyBreakIndexes @"RVProtocolCommandKeyBreakIndexes"
/*
 RVProtocolCommandKeyBreakDuration: NSTimeInterval wrapped in NSValue defining the number of micro seconds for which to pause
 */
#define RVProtocolCommandKeyBreakDuration @"RVProtocolCommandKeyBreakDuration"
/*
 RVProtocolCommandKeySplitDelimiter: NSString to split the command on.
 */
#define RVProtocolCommandKeySplitDelimiter @"RVProtocolCommandKeySplitDelimiter"


// keys for the params dictionaries
/*
 RVProtocolCommandKeyParamName: display name of parameter
 REQUIRED
 */
#define RVProtocolCommandKeyParamName @"RVProtocolCommandKeyParamName"
/*
 RVProtocolCommandKeyParamValue: returned value from user input
 RETURNED
 */
#define RVProtocolCommandKeyParamValue @"RVProtocolCommandKeyParamValue"
/*
 RVProtocolCommandKeyParamReplaceRange: NSRange wrapped in NSValue that specifies the range of the string to replace the input value with
 REQUIRED
 */
#define RVProtocolCommandKeyParamReplaceRange @"RVProtocolCommandKeyParamReplaceRange"
/*
 RVProtocolCommandKeyParamPossibleValues: array of strings to use as selectable values in a drop down menu
 OPTIONAL
 */
#define RVProtocolCommandKeyParamPossibleValues @"RVProtocolCommandKeyParamPossibleValues"
/*
 RVProtocolCommandKeyParamParseBeforeSplitting: Whether to replace this value before splitting the command by delimiter
 OPTIONAL
 */
#define RVProtocolCommandKeyParamParseBeforeSplitting @"RVProtocolCommandKeyParamParseBeforeSplitting"
/*
 RVProtocolCommandKeyParamParseBeforeSplitting: Whether to replace this value before splitting the command by delimiter
 OPTIONAL
 */
#define RVProtocolCommandKeyParamSplitDelimiter @"RVProtocolCommandKeyParamSplitDelimiter"


// DMX Only
/*
 RVProtocolCommandDMXChannelArray: array of dictionaries, each specifying a channel and value
 OPTIONAL
 */
#define RVProtocolCommandDMXChannelArray @"RVProtocolCommandDMXChannelArray"
/*
 RVProtocolCommandDMXChannel: NSNumber containing the DMX channel
 OPTIONAL
 */
#define RVProtocolCommandDMXChannel @"RVProtocolCommandDMXChannel"
/*
 RVProtocolCommandDMXValue: NSNumber containing the DMX value
 OPTIONAL
 */
#define RVProtocolCommandDMXValue @"RVProtocolCommandDMXValue"


#endif
